 /******************************************************************************		
*                                                                                   	
*       Copyright (C) 2006 Freescale Semiconductor, Inc.                            	
*       All Rights Reserved								              				
*														              					
* Filename:       vector.c               											
*														              					
* Description:	     	       						
*																						
* Notes:        																		
*  ***********************************************************************  			
*  *  THIS CODE IS ONLY INTENDED AS AN EXAMPLE OF CODE FOR THE           *  	 		
*  *  FREESCALE CW COMPILER AND HAS ONLY BEEN GIVEN A MIMIMUM            *  	 		
*  *  LEVEL OF TEST. IT IS PROVIDED 'AS SEEN' WITH NO GUARANTEES         *  	 		
*  *  AND NO PROMISE OF SUPPORT.                                         *  	 		
*  ***********************************************************************  	 		
*																						
* Freescale reserves the right to make changes without further notice to any			
* product herein to improve reliability, function, or design. Freescale does	 		
* not assume any  liability arising  out  of the  application or use of any 	 		
* product,  circuit, or software described herein;  neither  does it convey 	 		
* any license under its patent rights  nor the  rights of others.  Freescale	 		
* products are not designed, intended,  or authorized for use as components 	 		
* in  systems  intended  for  surgical  implant  into  the  body, or  other 	 		
* applications intended to support life, or  for any  other application  in 	 		
* which the failure of the Freescale product  could create a situation where	 		
* personal injury or death may occur. Should Buyer purchase or use Freescale	 		
* products for any such intended  or unauthorized  application, Buyer shall 	 		
* indemnify and  hold  Freescale  and its officers, employees, subsidiaries,	 		
* affiliates,  and distributors harmless against all claims costs, damages, 	  		
* and expenses, and reasonable  attorney  fees arising  out of, directly or 	 		
* indirectly,  any claim of personal injury  or death  associated with such 	 		
* unintended or unauthorized use, even if such claim alleges that  Freescale	 		
* was negligent regarding the  design  or manufacture of the part. Freescale	 		
* and the Freescale logo* are registered trademarks of Freescale Ltd.       	 		
******************************************************************************/	

  #define VECTOR_C
/******************************************************************************    	
*                                                                                      
*       Copyright (C) 2005 Freescale Semiconductor, Inc.                               
*       All Rights Reserved								              		    	
*														              			    	
* Filename:     vector.c                										    	
*														              			     	
* Functions:    Vector table for S08GB60                                      
*												                            	    	
* Description:  This file contains vectors tables for S08GB60 MCU		        
*																					    
* Notes:        																	    
*																				    	
******************************************************************************/    	
																				    	
																					    
#include    <startup.h>                             /* startup routine declaration  */ 
																					    
extern void _Startup( void );                      /* reset vector */	                

extern void RTI_ISR( void );                       /* RTI vector */	                
																				    
																					    
/******************************************************************************		
 *                                                                                     
 * Function:     DummyISR()                										
 *														              			        
 * Description:  dummy interrupt handler                                        	    
 *                                                                                     
 * Returns: no return value                                                            
 *																				        
 * Notes:        														     		    
 *																		    		    
 ******************************************************************************/       
static interrupt void DummyISR(void)											    
{	    																			    
	while(1);																		    
}   																				    
																					    
																					    
/******************************************************************************        
    INTERRUPT VECTORS TABLE                                                            
    User is able to add another ISR into this table instead NULL pointer.              
******************************************************************************/        
																					   
#if !defined(NULL)                                                                     
#define NULL    (0)                                                                    
#endif /* !defined(NULL) */                                                            
																					   
#undef  LIN_VECTF                                                                      
																					   
																					   
#define LIN_VECTF   ( void ( *const near )( ) )     /* Vector table function specifier   */

#pragma CONST_SEG VECTORS_DATA

void near ( * const near _vectab[] )( ) =   

{
	LIN_VECTF	RTI_ISR,			/* 0xFFCC:	RTI		            */
	LIN_VECTF	DummyISR,			/* 0xFFCE:	IIC		            */
	LIN_VECTF	DummyISR,			/* 0xFFD0:	ADC Conversion		*/
	LIN_VECTF	DummyISR,			/* 0xFFD2:	Keyboard	    	*/
	LIN_VECTF	DummyISR,			/* 0xFFD4:	SCI2 Transmit		*/
	LIN_VECTF	DummyISR,			/* 0xFFD6:	SCI2 Receive		*/
	LIN_VECTF	DummyISR,			/* 0xFFD8:	SCI2 Error		    */
	LIN_VECTF	DummyISR,			/* 0xFFDA:	SCI1 Transmit		*/
	LIN_VECTF	DummyISR,			/* 0xFFDC:	SCI1 Receive		*/
	LIN_VECTF	DummyISR,			/* 0xFFDE:	SCI1 Error	    	*/
	LIN_VECTF	DummyISR,			/* 0xFFE0:	SPI		            */
	LIN_VECTF	DummyISR,			/* 0xFFE2:	TPM2 Overflow		*/
	LIN_VECTF	DummyISR,			/* 0xFFE4:	TPM2 Channel 4		*/
	LIN_VECTF	DummyISR,			/* 0xFFE6:	TPM2 Channel 3		*/
	LIN_VECTF	DummyISR,			/* 0xFFE8:	TPM2 Channel 2		*/
	LIN_VECTF	DummyISR,			/* 0xFFEA:	TPM2 Channel 1		*/
	LIN_VECTF	DummyISR,			/* 0xFFEC:	TPM2 Channel 0		*/
	LIN_VECTF	DummyISR,			/* 0xFFEE:	TPM1 Overflow		*/
	LIN_VECTF	DummyISR,			/* 0xFFF0:	TPM1 Channel 2		*/
	LIN_VECTF	DummyISR,			/* 0xFFF2:	TPM1 Channel 1		*/
	LIN_VECTF	DummyISR,           /* 0xFFF4:	TPM1 Channel 0		*/
	LIN_VECTF	DummyISR,			/* 0xFFF6:	ICG		            */
	LIN_VECTF	DummyISR,			/* 0xFFF8:	Low Voltage Detect  */
	LIN_VECTF	DummyISR,			/* 0xFFFA:	IRQ	            	*/
	LIN_VECTF	DummyISR,			/* 0xFFFC:	SWI		            */
	LIN_VECTF	_Startup,			/* 0xFFFE:	Reset		        */
};